/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.contracts.controller;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.ErpObjectContainer;
import itx.erp.base.model.User;
import itx.erp.base.service.UserService;
import itx.erp.base.util.LangUtil;
import itx.erp.contracts.model.Contract;
import itx.erp.contracts.service.ContractService;
import itx.erp.helper.ErpConfig;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import jtbcore.db.common.QueryResult;
import jtbcore.db.export.ExcelExporter;
import jtbcore.exception.FileException;
import jtbcore.util.DateUtil;
import jtbcore.util.ProcUtil;

public class ContractListController
extends BaseController {
    protected ErpConfig appConfig;
    protected ContractService contractService;
    protected UserService userService;

    public ErpConfig getAppConfig() {
        return this.appConfig;
    }

    public void setAppConfig(ErpConfig appConfig) {
        this.appConfig = appConfig;
    }

    public ContractService getContractService() {
        return this.contractService;
    }

    public void setContractService(ContractService contractService) {
        this.contractService = contractService;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    @Override
    public void handleRequest(WebRequest webRequest) throws Exception {
        super.executeAction(webRequest);
    }

    public void indexAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException {
        Integer excludeContractId = req.getParamInt("excludeContractId");
        Integer pageNo = req.getParamInt("pageNo", 0);
        Integer pageSize = req.getParamInt("pageSize");
        if (pageSize == null) {
            pageSize = this.appConfig.getLimit();
        }
        HashMap<String, Object> opts = new HashMap<String, Object>();
        opts.put("start", pageNo * pageSize);
        opts.put("pageSize", pageSize);
        opts.put("dbFileId", req.getParamInt("dbFileId"));
        opts.put("excludeContractId", req.getParamInt("excludeContractId"));
        opts.put("relatedContractId", req.getParamInt("relatedContractId"));
        if (req.hasParameter("cid")) {
            opts.put("customerId", req.getParamInt("cid"));
        }
        opts.put("q", req.getParameter("q"));
        opts.put("st_open", req.getParamBool("st_open"));
        opts.put("st_negotiation", req.getParamBool("st_negotiation"));
        opts.put("st_reviewal", req.getParamBool("st_reviewal"));
        opts.put("st_accepted", req.getParamBool("st_accepted"));
        opts.put("st_active", req.getParamBool("st_active"));
        opts.put("st_expiring", req.getParamBool("st_expiring"));
        opts.put("st_terminated", req.getParamBool("st_terminated"));
        Integer userId = req.getUserId();
        opts.put("allowedUserId", userId);
        QueryResult<Contract> qr = this.contractService.searchContract(opts);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("contracts", qr.getObjects());
        result.put("start", qr.getStart());
        result.put("pageSize", qr.getPageSize());
        result.put("rowCount", qr.getRowCount());
        if (excludeContractId != null) {
            result.put("linkedContractIds", this.contractService.linkedContractIds(excludeContractId));
        }
        req.renderJson(result);
    }

    public void exportAction(WebRequest req) throws SQLException, FileException, IOException {
        User user = this.userService.readUser(req.getUserId());
        String tempfile = ErpObjectContainer.getInstance().getTempFile("contract-export-" + DateUtil.date2string(new Date()) + ".xlsx");
        ExcelExporter e = new ExcelExporter(tempfile);
        e.writeHeader(new String[]{"#", "Contract", "Relatie", "Waarde", "Contract type", "Startdatum", "Einddatum", "Verlengdatum", "Verlengperiode", "Opzegtermijn", "Automatisch verlengen", "Status"});
        int start = 0;
        int pageSize = 100;
        HashMap<String, Object> opts = new HashMap<String, Object>();
        opts.put("start", start);
        opts.put("pageSize", pageSize);
        opts.put("allowedUserId", user.getUserId());
        LangUtil lu = LangUtil.getInstance();
        QueryResult<Contract> qr = null;
        qr = this.contractService.searchContract(opts);
        int counter = 0;
        do {
            List<Contract> contracts = qr.getObjects();
            int x = 0;
            while (x < contracts.size()) {
                Contract c = contracts.get(x);
                ArrayList<Object> row = new ArrayList<Object>();
                row.add(c.getContractId());
                row.add(c.getName());
                row.add(c.getCustomerName());
                row.add(c.getAmountDescription());
                row.add(c.getContractTypeName());
                row.add(c.getStartDate());
                row.add(c.getEndDate());
                row.add(c.getRenewalDate());
                if (c.getRenewPeriod() != null && c.getRenewPeriod() != 0) {
                    String renewalPeriod = String.valueOf(c.getRenewPeriod()) + " " + lu.t(c.getRenewUnit());
                    row.add(renewalPeriod);
                } else {
                    row.add("");
                }
                if (c.getTimeNotice() != null && c.getTimeNotice() != 0) {
                    String timeNotice = String.valueOf(c.getTimeNotice()) + " " + lu.t(c.getTimeNoticeUnit());
                    row.add(timeNotice);
                } else {
                    row.add("");
                }
                row.add(c.getAutoRenew() ? "Ja" : "Nee");
                row.add(lu.t("contract_status." + c.getStatus()));
                e.writeRow(row);
                ++x;
            }
            opts.put("start", start += pageSize);
            if (start > qr.getRowCount()) break;
            qr = this.contractService.searchContract(opts);
        } while (counter++ <= 100000);
        e.closeFile();
        if (req.isEmbeddedRequest()) {
            ProcUtil.openUrlInBrowser(tempfile);
        } else {
            req.outputFile(tempfile);
        }
    }

    public void recentAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException {
        HashMap<String, Object> opts = new HashMap<String, Object>();
        opts.put("start", 0);
        opts.put("pageSize", 25);
        opts.put("orderby", "contract__contract.edited desc");
        Integer userId = req.getUserId();
        opts.put("allowedUserId", userId);
        QueryResult<Contract> qr = this.contractService.searchContract(opts);
        HashMap<String, List<Contract>> result = new HashMap<String, List<Contract>>();
        result.put("contracts", qr.getObjects());
        req.renderJson(result);
    }
}

